﻿Add-Type -assembly System.Windows.Forms
$main_form = New-Object System.Windows.Forms.Form
$main_form.Text ='Netzbest Laptop Tool V0.1'
$main_form.Width = 200
$main_form.Height = 200
$main_form.AutoSize = $true
$Label = New-Object System.Windows.Forms.Label
$Label.Text = "N-Nummer"
$Label.Location  = New-Object System.Drawing.Point(0,40)
$Label.AutoSize = $true
$textBox = New-Object System.Windows.Forms.TextBox
$textBox.Location  = New-Object System.Drawing.Point(100,40)
$okButton = New-Object System.Windows.Forms.Button
$okButton.Location = New-Object System.Drawing.Point(300,170)
$okButton.Size = New-Object System.Drawing.Size(75,23)
$okButton.Text = 'OK'
$okButton.DialogResult = [System.Windows.Forms.DialogResult]::OK
$Label3 = New-Object System.Windows.Forms.Label
$Label3.Text = "Bitte geben Sie die N-Nummer des Gerätes ein."
$Label3.Location  = New-Object System.Drawing.Point(0,10)
$Label3.AutoSize = $true
$main_form.AcceptButton = $okButton
$main_form.Controls.Add($okButton)
$main_form.Controls.Add($Label)
$main_form.Controls.Add($Label3)
$main_form.Controls.Add($textBox)
$main_form.ShowDialog()
$NNumber = $textBox.Text
$Admin = $NNumber+'-admin'
$path = $PSScriptRoot
$DeinstallPath = $path+'\Delete Default Apps\Windows10SysPrepDebloater.ps1'
$OfficePath = $path+'\office.exe'
$ConfigPath = $path+'\Config.xml'
$TeamsInstaller = $path+'\teamsbootstrapper.exe'
##Remove Lenovo
If (!([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole(`
    [Security.Principal.WindowsBuiltInRole] "Administrator")) 
    {
        Write-Warning "You are not running as Admin."
        Break
    }
 

#uninstall apps
$AppList = "E046963F.LenovoCompanion",           
           "LenovoCorporation.LenovoSettings",
           "E046963F.LenovoSettingsforEnterprise"

cls
Write-Warning "Bitte Warten Sie und schalten Sie nicht den Laptop aus. Wir führen ein wichtiges BIOS Update durch"
ForEach ($App in $AppList)
{
   $PackageFullName = (Get-AppxPackage -allusers $App).PackageFullName
   $ProPackageFullName = (Get-AppxProvisionedPackage -online | where {$_.Displayname -eq $App}).PackageName
  
   ForEach ($AppToRemove in $PackageFullName)
   {
     Write-Host "Removing Package: $AppToRemove"
     try
     {
        remove-AppxPackage -package $AppToRemove -allusers
     }
     catch
     {
        # Starting in Win10 20H1, bundle apps (like Vantage) have to be removed a different way
        $PackageBundleName = (Get-AppxPackage -packagetypefilter bundle -allusers $App).PackageFullName
        ForEach ($BundleAppToRemove in $PackageBundleName)
        {
           remove-AppxPackage -package $BundleAppToRemove -allusers
        }
     }
   }

   ForEach ($AppToRemove in $ProPackageFullName)
   {
     Write-Host "Removing Provisioned Package: $AppToRemove"
     try
     {
        Remove-AppxProvisionedPackage -online -packagename $AppToRemove
     }
     catch
     {
        # bundled/provisioned apps are already removed by "remove-AppxPackage -allusers"
     }
   }

}

#get lenovo vantage service uninstall string to uninstall service
$lvs = Get-ItemProperty "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\*", "HKLM:\Software\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\*" | where DisplayName -eq "Lenovo Vantage Service"
If (!([string]::IsNullOrEmpty($lvs.QuietUninstallString)))
{
   $uninstall = "cmd /c " + $lvs.QuietUninstallString
   Write-Host $uninstall
   Invoke-Expression $uninstall
}
 

#uninstall ImController service
Invoke-Expression -Command 'cmd.exe /c "c:\windows\system32\ImController.InfInstaller.exe" -uninstall'

#remove vantage associated registry keys
Remove-Item 'HKLM:\SOFTWARE\Policies\Lenovo\E046963F.LenovoCompanion_k1h2ywk1493x8' -Recurse -ErrorAction SilentlyContinue
Remove-Item 'HKLM:\SOFTWARE\Policies\Lenovo\ImController' -Recurse -ErrorAction SilentlyContinue
Remove-Item 'HKLM:\SOFTWARE\Policies\Lenovo\Lenovo Vantage' -Recurse -ErrorAction SilentlyContinue
Remove-Item 'HKLM:\SOFTWARE\Policies\Lenovo\Commercial Vantage' -Recurse -ErrorAction SilentlyContinue

##Deinstall everything
. $DeinstallPath -Sysprep -Debloat -Privacy
##install Ninja
function disableWindowsHello{
$regHive='REGISTRY::HKLM\SOFTWARE\Policies\Microsoft\PassportForWork'
$refreshEnv=$false
if (!(Test-Path $regHive)){
Write-Host "Creating registry path $regHive"
New-Item -Path $regHive -Force
}
if ((get-itemproperty $regHive -EA Ignore).Enabled -ne 0){
New-ItemProperty -Path $regHive -Name 'Enabled' -Value 0 -PropertyType DWORD -Force
$refreshEnv=$true
}
if ((get-itemproperty $regHive -EA Ignore).DisablePostLogonProvisioning -ne 1){
New-ItemProperty -Path $regHive -Name 'DisablePostLogonProvisioning' -Value 1 -PropertyType DWORD -Force
$refreshEnv=$true
}
if($refreshEnv){
write-host 'refreshing environment...'
& 'RUNDLL32.EXE' USER32.DLL, UpdatePerUserSystemParameters 1, True
}
write-host "Windows Hello has been disabled on $env:computername"
}
disableWindowsHello
msiexec.exe /i "https://download.netzbest.de/Ninja.msi"
##install office
Start-Process $OfficePath -ArgumentList "/configure $ConfigPath"
Start-Process -FilePath "$TeamsInstaller" -ArgumentList "-p"
##Rename Computer and restart
##$adminuser = 'localhost\'+$Admin
##Rename-Computer -NewName $NNumber -LocalCredential $adminuser -Restart